import { applyDecorators } from '@nestjs/common';
import {
  ApiCreatedResponse,
  ApiBadRequestResponse,
  ApiUnauthorizedResponse,
} from '@nestjs/swagger';

const PASSWORD_RULE =
  /^(?=.*[A-Z])(?=.*[a-z])(?=.*\d)(?=.*[!@#$%^&*()_+])[A-Za-z\d!@#$%^&*()_+]{8,16}$/;

const PASSWORD_RULE_MESSAGE =
  'Password should have 1 uppercase lowercase letter and number and special character';

//swagger default reposnse decorators
export function ApiDefaultResponses(successDescription: string) {
  return applyDecorators(
    ApiCreatedResponse({ description: successDescription }),
    ApiBadRequestResponse({ description: 'Bad Request! Check the input.' }),
    ApiUnauthorizedResponse({
      description: 'Unauthorized! Token is invalid or missing.',
    }),
  );
}
export const REGEX = {
  PASSWORD_RULE,
};

export const MESSAGES = {
  PASSWORD_RULE_MESSAGE,
};
