/*
https://docs.nestjs.com/providers#services
*/

import { Injectable, NotFoundException } from '@nestjs/common';
import { User } from 'src/entity/user.entity';
import { Repository } from 'typeorm';
import { InjectRepository } from '@nestjs/typeorm';
import { UserRegistrationRequestDto } from 'src/dto/user-registration.req.dto';
import * as bcrypt from 'bcrypt';

@Injectable()
export class UserService {
  constructor(
    @InjectRepository(User)
    private userRepository: Repository<User>,
  ) {}

  async doUserRegistration(
    registerUserData: UserRegistrationRequestDto,
  ): Promise<User> {
    if (registerUserData.Password != registerUserData.ConfirmPass) {
      throw new Error('Passwords do not match!');
    }
    const user = new User();
    user.Name = registerUserData.Name;
    user.Email = registerUserData.Email;
    user.Password = registerUserData.Password;
    return this.userRepository.save(user);
  }

  async getAllUsers(): Promise<User[]> {
    return this.userRepository.find();
  }

  async getUserByEmail(Email: string): Promise<any> {
    return this.userRepository.findOneBy({ Email: Email });
  }

  async updateUser(id: number, userData: UserRegistrationRequestDto) {
    const getExisting = await this.userRepository.findOneBy({ idUser: id });

    if (!getExisting) {
      throw new NotFoundException();
    }

    if (userData.Password != userData.ConfirmPass) {
      throw new Error('Passwords do not match!');
    }

    getExisting.Name = userData.Name;
    getExisting.Email = userData.Email;
    getExisting.Password = userData.Password;

    return await this.userRepository.save(getExisting);
  }
}
