import {
  Body,
  Put,
  Controller,
  Get,
  HttpCode,
  Param,
  Post,
  UsePipes,
  ValidationPipe,
  UseGuards,
} from '@nestjs/common';
import { CreateContactusDto } from '../dto/create-contactus.dto';
import { Contactus } from '../entity/contactus.entity';
import { ContactusService } from '../services/contactus.service';
import { JwtAuthGuard } from 'src/auth/guards/jwt-auth-guard';
const nodemailer = require('nodemailer');

import {
  ApiBadRequestResponse,
  ApiBearerAuth,
  ApiCreatedResponse,
  ApiUnauthorizedResponse,
} from '@nestjs/swagger';
import { ApiDefaultResponses } from 'src/utils/common.utils';

@Controller('api/contactus')
export class ContactusController {
  constructor(private contactusDbService: ContactusService) {}

  @UseGuards(JwtAuthGuard)
  @Get('/')
  @ApiDefaultResponses('Get All completed!')
  @ApiBearerAuth() //this tells swagger to use authorisation
  //in here im adding Contactus[] -  we are returning an array of Contactus objects
  async getAllContactus(): Promise<Contactus[]> {
    return await this.contactusDbService.getAllContactus();
  }

  @Post('/')
  @ApiDefaultResponses('Adding completed!')
  @UsePipes(ValidationPipe)
  async addContactUs(
    @Body() contactusData: CreateContactusDto,
  ): Promise<Contactus> {
    const savedContact =
      await this.contactusDbService.addContactUs(contactusData);
    // Configure the email transporter
    const transporter = nodemailer.createTransport({
      host: 'optimizesolutions.lk', // Replace with your email provider's SMTP server
      port: 465, // Usually 587 for TLS
      secure: true, // Use true for 465, false for 587
      auth: {
        user: 'mailservice@optimizesolutions.lk', // Your email address
        pass: '963580398Vj*', // Your email password or app-specific password
      },
    });

    // Email content
    const mailOptions = {
      from: '"Optimize Solutions" <mailservice@optimizesolutions.lk>',
      to: 'isuruchandika321@gmail.com',
      subject: 'New Contact Message Received',
      text: `A new contact message has been received:
        Name: ${contactusData.Name}
        Email: ${contactusData.Email}
        Contact Number: ${contactusData.Phone}
        Message: ${contactusData.Birthday}
      `,
      html: `
        <div style="font-family: Arial, sans-serif; color: #333;">
          <div style="padding: 20px; background-color: #f7f7f7; border: 1px solid #ddd; border-radius: 10px;">
            <h2 style="color: #444;">New Message</h2>
            <p style="font-size: 16px;">Dear Team,</p>
            <p style="font-size: 16px;">A new message has been received:</p>
            <ul style="font-size: 16px; list-style: none; padding: 0;">
              <li><strong>Name:</strong> ${contactusData.Name}</li>
              <li><strong>Email:</strong> ${contactusData.Email}</li>
              <li><strong>Contact Number:</strong> ${contactusData.Phone}</li>
              <li><strong>Message:</strong> ${contactusData.Birthday}</li>
            </ul>
            <p style="font-size: 16px; margin-top: 30px;">Thank you,</p>
            <p style="font-size: 16px; font-weight: bold;">Team Optimize Solutions</p>
          </div>
          <div style="text-align: center; padding: 20px 0; font-size: 12px; color: #888;">
            <p>&copy; 2024 Optimize Solutions. All rights reserved.</p>
          </div>
        </div>
      `,
    };

    // Send the email
    await transporter.sendMail(mailOptions);

    return savedContact;
  }

  @UseGuards(JwtAuthGuard)
  @Get('/:id')
  @ApiDefaultResponses('Get by id completed!')
  @HttpCode(200)
  @ApiBearerAuth() //this tells swagger to use authorisation
  async getContactusById(@Param('id') id: number): Promise<Contactus> {
    return await this.contactusDbService.getContactusById(id);
  }

  @UseGuards(JwtAuthGuard)
  @Put('/:id')
  @ApiDefaultResponses('updating completed!')
  @UsePipes(ValidationPipe)
  @ApiBearerAuth() //this tells swagger to use authorisation
  async updateContactById(
    @Param('id') id: number,
    @Body() contactusData: CreateContactusDto,
  ): Promise<Contactus> {
    return await this.contactusDbService.updateContactById(id, contactusData);
  }
}
