/*
https://docs.nestjs.com/controllers#controllers
*/

import { Controller, Post, UseGuards, Request } from '@nestjs/common';
import { AuthService } from './auth.service';
import { LocalAuthGuard } from './guards/local-auth.guard';
import { LoginDto } from 'src/dto/login.dto';
import { ApiBody } from '@nestjs/swagger';
import { ApiDefaultResponses } from 'src/utils/common.utils';
@Controller('api/auth')
export class AuthController {
  constructor(private authDbService: AuthService) {}

  @UseGuards(LocalAuthGuard)
  @Post('/login')
  @ApiBody({ type: LoginDto })
  @ApiDefaultResponses('Login success!')
  async login(@Request() req): Promise<any> {
    console.log(req.user);
    const token = await this.authDbService.genarateToken(req.user);
    return {
      message: 'Login success!',
      user: req.user,
      token: token,
    };
  }
}
