"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MESSAGES = exports.REGEX = void 0;
exports.ApiDefaultResponses = ApiDefaultResponses;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const PASSWORD_RULE = /^(?=.*[A-Z])(?=.*[a-z])(?=.*\d)(?=.*[!@#$%^&*()_+])[A-Za-z\d!@#$%^&*()_+]{8,16}$/;
const PASSWORD_RULE_MESSAGE = 'Password should have 1 uppercase lowercase letter and number and special character';
function ApiDefaultResponses(successDescription) {
    return (0, common_1.applyDecorators)((0, swagger_1.ApiCreatedResponse)({ description: successDescription }), (0, swagger_1.ApiBadRequestResponse)({ description: 'Bad Request! Check the input.' }), (0, swagger_1.ApiUnauthorizedResponse)({
        description: 'Unauthorized! Token is invalid or missing.',
    }));
}
exports.REGEX = {
    PASSWORD_RULE,
};
exports.MESSAGES = {
    PASSWORD_RULE_MESSAGE,
};
//# sourceMappingURL=common.utils.js.map