"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserRegistrationRequestDto = void 0;
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const common_utils_1 = require("../utils/common.utils");
class UserRegistrationRequestDto {
}
exports.UserRegistrationRequestDto = UserRegistrationRequestDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'The name of the user!',
        example: 'isuru chandika',
    }),
    (0, class_validator_1.IsNotEmpty)({ message: 'Name is required!' }),
    (0, class_validator_1.Length)(3.255),
    __metadata("design:type", String)
], UserRegistrationRequestDto.prototype, "Name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'The user email',
        example: 'isururathnayaka321@gmail.com',
    }),
    (0, class_validator_1.IsNotEmpty)({ message: 'Email is required!' }),
    (0, class_validator_1.IsEmail)(),
    (0, class_validator_1.Length)(3.255),
    __metadata("design:type", String)
], UserRegistrationRequestDto.prototype, "Email", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Password',
        example: 'Isuru@123',
    }),
    (0, class_validator_1.IsNotEmpty)({ message: 'Password is required!' }),
    (0, class_validator_1.Matches)(common_utils_1.REGEX.PASSWORD_RULE, {
        message: 'Password should have 1 uppercase lowercase letter and number and special character',
    }),
    __metadata("design:type", String)
], UserRegistrationRequestDto.prototype, "Password", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Pasword Retype',
        example: 'Isuru@123',
    }),
    (0, class_validator_1.IsNotEmpty)({ message: 'Confirm Password is required!' }),
    (0, class_validator_1.Matches)(common_utils_1.REGEX.PASSWORD_RULE, {
        message: common_utils_1.MESSAGES.PASSWORD_RULE_MESSAGE,
    }),
    __metadata("design:type", String)
], UserRegistrationRequestDto.prototype, "ConfirmPass", void 0);
//# sourceMappingURL=user-registration.req.dto.js.map