"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthService = void 0;
const common_1 = require("@nestjs/common");
const user_service_1 = require("../services/user.service");
const bcrypt = require("bcrypt");
const jwt_1 = require("@nestjs/jwt");
let AuthService = class AuthService {
    constructor(userDbService, jwtService) {
        this.userDbService = userDbService;
        this.jwtService = jwtService;
    }
    async validateUserCredintials(Email, Password) {
        console.log('Email is : ', Email);
        console.log('Password is : ', Password);
        const user = await this.userDbService.getUserByEmail(Email);
        if (!user) {
            throw new common_1.BadRequestException();
        }
        if (!(await bcrypt.compare(Password, user.Password))) {
            throw new common_1.UnauthorizedException();
        }
        return user;
    }
    async genarateToken(user) {
        const access_token = this.jwtService.sign({
            Name: user.Name,
            sub: user.idUser,
        });
        return { access_token: access_token };
    }
};
exports.AuthService = AuthService;
exports.AuthService = AuthService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [user_service_1.UserService,
        jwt_1.JwtService])
], AuthService);
//# sourceMappingURL=auth.service.js.map